<?php 
$pageTitle = 'Consultorias, Análises e Projetos - Sierro Engenharia';
include 'header.php'; 
?>

<!-- Hero Section -->
<section class="hero-banner">
    <div class="container">
        <div class="hero-content">
            <h1 class="animate-up">Consultorias, Análises e Projetos</h1>
            <div class="hero-divider animate-up"></div>
            <p class="hero-subtitle animate-up">Soluções customizadas para otimização industrial</p>
        </div>
    </div>
</section>

<!-- Conteúdo Principal -->
<main class="main-content">
    <div class="container">
        <!-- Grid Principal -->
        <div class="content-grid">
            <!-- Coluna de Texto -->
            <div class="text-column" data-aos="fade-right">
                <div class="text-content">
                    <div class="text-block">
                        <div class="section-tag">Otimização de Processos</div>
                        <p>
                            Na Sierro Engenharia, nossos serviços de Consultorias, Análises e Projetos são focados em identificar e implementar melhorias contínuas na linha de produção, com o objetivo de otimizar a performance e maximizar a eficiência operacional.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Desenvolvimento Colaborativo</div>
                        <p>
                            Atuamos em conjunto com nossos clientes para desenvolver soluções personalizadas, que resultem em aumento de produtividade, redução de desperdícios e economia de recursos.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Abordagem Personalizada</div>
                        <p>
                            Através de uma análise detalhada dos processos produtivos e das necessidades específicas de cada cliente, desenvolvemos projetos sob medida que proporcionam melhorias tangíveis em cada etapa da produção.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Inovação Sustentável</div>
                        <p>
                            Desde a automação de processos até a integração de novas tecnologias, nossa abordagem busca sempre o equilíbrio entre performance e sustentabilidade, garantindo resultados consistentes e duradouros.
                        </p>
                    </div>

                    <!-- Serviços Cards -->
                    <div class="services-section">
                        <h3 class="services-title">Nossos Serviços de Consultoria</h3>
                        <div class="services-grid">
                            <div class="service-card" data-aos="fade-up">
                                <div class="service-icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <h4>Análise de Eficiência</h4>
                                <p>Avaliação completa dos processos produtivos para identificação de gargalos e oportunidades de melhoria.</p>
                            </div>

                            <div class="service-card" data-aos="fade-up" data-aos-delay="100">
                                <div class="service-icon">
                                    <i class="fas fa-cogs"></i>
                                </div>
                                <h4>Otimização de Processos</h4>
                                <p>Reestruturação de fluxos de trabalho para maximizar eficiência e minimizar tempos ociosos.</p>
                            </div>

                            <div class="service-card" data-aos="fade-up" data-aos-delay="200">
                                <div class="service-icon">
                                    <i class="fas fa-industry"></i>
                                </div>
                                <h4>Automação Industrial</h4>
                                <p>Desenvolvimento de soluções para automatizar processos e aumentar a precisão e velocidade da produção.</p>
                            </div>

                            <div class="service-card" data-aos="fade-up" data-aos-delay="300">
                                <div class="service-icon">
                                    <i class="fas fa-leaf"></i>
                                </div>
                                <h4>Sustentabilidade</h4>
                                <p>Implementação de práticas e tecnologias para reduzir o impacto ambiental e otimizar o uso de recursos.</p>
                            </div>

                            <div class="service-card" data-aos="fade-up" data-aos-delay="400">
                                <div class="service-icon">
                                    <i class="fas fa-tools"></i>
                                </div>
                                <h4>Manutenção Preditiva</h4>
                                <p>Estratégias de monitoramento e manutenção para prevenir falhas e aumentar a vida útil dos equipamentos.</p>
                            </div>

                            <div class="service-card" data-aos="fade-up" data-aos-delay="500">
                                <div class="service-icon">
                                    <i class="fas fa-drafting-compass"></i>
                                </div>
                                <h4>Projetos de Expansão</h4>
                                <p>Planejamento e execução de projetos para expansão de capacidade produtiva com integração aos sistemas existentes.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Metodologia -->
                    <div class="methodology-section">
                        <h3 class="methodology-title">Nossa Metodologia</h3>
                        <div class="methodology-flow">
                            <div class="methodology-step" data-aos="zoom-in-right">
                                <div class="step-number">01</div>
                                <div class="step-content">
                                    <h4>Diagnóstico</h4>
                                    <p>Análise detalhada da situação atual, identificando pontos críticos e oportunidades.</p>
                                </div>
                            </div>
                            <div class="methodology-divider"></div>
                            <div class="methodology-step" data-aos="zoom-in-right" data-aos-delay="100">
                                <div class="step-number">02</div>
                                <div class="step-content">
                                    <h4>Planejamento</h4>
                                    <p>Desenvolvimento de estratégias e soluções personalizadas para cada desafio identificado.</p>
                                </div>
                            </div>
                            <div class="methodology-divider"></div>
                            <div class="methodology-step" data-aos="zoom-in-right" data-aos-delay="200">
                                <div class="step-number">03</div>
                                <div class="step-content">
                                    <h4>Implementação</h4>
                                    <p>Execução coordenada das soluções com acompanhamento técnico especializado.</p>
                                </div>
                            </div>
                            <div class="methodology-divider"></div>
                            <div class="methodology-step" data-aos="zoom-in-right" data-aos-delay="300">
                                <div class="step-number">04</div>
                                <div class="step-content">
                                    <h4>Monitoramento</h4>
                                    <p>Acompanhamento contínuo dos resultados e ajustes para garantir a eficácia das soluções.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="cta-section">
                        <div class="cta-content">
                            <h2>Vamos otimizar seus processos produtivos</h2>
                            <p>Entre em contato para uma análise personalizada das necessidades do seu negócio</p>
                            <a href="contato.php" class="cta-button">
                                <span>Solicitar Consultoria</span>
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Coluna da Imagem -->
            <div class="image-column" data-aos="fade-left">
                <div class="image-sticky">
                    <div class="main-image">
                        <img src="images/excelencia.png" alt="Consultorias e Análises Industriais - Sierro Engenharia">
                        <div class="image-overlay">
                            <div class="specs-list">
                                <div class="spec-item">
                                    <i class="fas fa-chart-pie"></i>
                                    <span>Análises Detalhadas</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-lightbulb"></i>
                                    <span>Soluções Inovadoras</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-handshake"></i>
                                    <span>Parceria Estratégica</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Resultados -->
                    <div class="results-box">
                        <h3 class="results-title">Resultados que Entregamos</h3>
                        <div class="results-grid">
                            <div class="result-item" data-aos="fade-up">
                                <div class="result-icon">
                                    <i class="fas fa-tachometer-alt"></i>
                                </div>
                                <div class="result-content">
                                    <h4>Aumento de Produtividade</h4>
                                    <div class="result-value">+30%</div>
                                </div>
                            </div>
                            
                            <div class="result-item" data-aos="fade-up" data-aos-delay="100">
                                <div class="result-icon">
                                    <i class="fas fa-cut"></i>
                                </div>
                                <div class="result-content">
                                    <h4>Redução de Desperdícios</h4>
                                    <div class="result-value">-25%</div>
                                </div>
                            </div>
                            
                            <div class="result-item" data-aos="fade-up" data-aos-delay="200">
                                <div class="result-icon">
                                    <i class="fas fa-bolt"></i>
                                </div>
                                <div class="result-content">
                                    <h4>Economia de Energia</h4>
                                    <div class="result-value">-20%</div>
                                </div>
                            </div>
                            
                            <div class="result-item" data-aos="fade-up" data-aos-delay="300">
                                <div class="result-icon">
                                    <i class="fas fa-stopwatch"></i>
                                </div>
                                <div class="result-content">
                                    <h4>Redução de Tempo de Inatividade</h4>
                                    <div class="result-value">-40%</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Depoimento -->
                    <div class="testimonial-card">
                        <div class="testimonial-icon">
                            <i class="fas fa-quote-left"></i>
                        </div>
                        <blockquote class="testimonial-text">
                            A consultoria da Sierro nos permitiu identificar oportunidades de melhoria que não havíamos percebido. Após a implementação das recomendações, observamos um aumento significativo na eficiência de nossa linha de produção.
                        </blockquote>
                        <div class="testimonial-author">
                            <div class="author-name">Diretor Industrial</div>
                            <div class="author-title">Empresa do setor alimentício</div>
                        </div>
                    </div>
                    
                    <!-- Setores Atendidos -->
                    <div class="sectors-box">
                        <h3 class="sectors-title">Setores Atendidos</h3>
                        <div class="sectors-grid">
                            <div class="sector-tag">
                                <i class="fas fa-utensils"></i>
                                <span>Alimentício</span>
                            </div>
                            <div class="sector-tag">
                                <i class="fas fa-flask"></i>
                                <span>Químico</span>
                            </div>
                            <div class="sector-tag">
                                <i class="fas fa-pills"></i>
                                <span>Farmacêutico</span>
                            </div>
                            <div class="sector-tag">
                                <i class="fas fa-wine-bottle"></i>
                                <span>Bebidas</span>
                            </div>
                            <div class="sector-tag">
                                <i class="fas fa-box"></i>
                                <span>Embalagens</span>
                            </div>
                            <div class="sector-tag">
                                <i class="fas fa-seedling"></i>
                                <span>Agroindustrial</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
/* Layout Principal */
.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

.main-content {
    padding: 80px 0;
    background: #f8f9fa;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

/* Hero Banner */
.hero-banner {
    background: linear-gradient(45deg, #00214e, #003175);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-banner::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 50%;
    height: 100%;
    background: url('assets/images/pattern.png') repeat;
    opacity: 0.1;
}

.hero-content {
    text-align: center;
    position: relative;
    z-index: 2;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto 20px;
}

.hero-subtitle {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* Texto e Conteúdo */
.text-column {
    padding-right: 40px;
}

.text-content {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.text-block {
    margin-bottom: 30px;
}

.section-tag {
    display: inline-block;
    padding: 8px 16px;
    background: #fff2f0;
    color: #e4451d;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 15px;
}

.text-block p {
    font-size: 1.2rem;
    line-height: 1.8;
    color: #444;
    text-align: justify;
    text-justify: inter-word;
    margin: 0;
}

/* Serviços Cards */
.services-section {
    margin: 50px 0;
}

.services-title {
    text-align: center;
    margin-bottom: 30px;
    color: #00214e;
    font-weight: 600;
}

.services-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 25px;
}

.service-card {
    background: #f8f9fa;
    border-radius: 15px;
    padding: 30px;
    transition: all 0.3s ease;
    text-align: center;
}

.service-card:hover {
    transform: translateY(-10px);
    background: #fff2f0;
    box-shadow: 0 15px 30px rgba(0,0,0,0.1);
}

.service-icon {
    width: 70px;
    height: 70px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
}

.service-icon i {
    font-size: 25px;
    color: #e4451d;
}

.service-card h4 {
    margin: 0 0 15px;
    color: #00214e;
    font-size: 1.3rem;
    font-weight: 600;
}

.service-card p {
    margin: 0;
    font-size: 0.95rem;
    color: #666;
    line-height: 1.6;
}

/* Metodologia */
.methodology-section {
    margin-top: 60px;
    padding: 30px;
    background: #f8f9fa;
    border-radius: 15px;
}

.methodology-title {
    text-align: center;
    margin-bottom: 30px;
    color: #00214e;
    font-weight: 600;
}

.methodology-flow {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.methodology-step {
    display: flex;
    align-items: flex-start;
    background: white;
    padding: 20px;
    border-radius: 10px;
    gap: 20px;
    transition: all 0.3s ease;
}

.methodology-step:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.05);
    background: #fff2f0;
}

.step-number {
    width: 50px;
    height: 50px;
    background: #00214e;
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    font-weight: 700;
    flex-shrink: 0;
}

.step-content {
    flex-grow: 1;
}

.step-content h4 {
    margin: 0 0 10px;
    color: #00214e;
    font-size: 1.2rem;
    font-weight: 600;
}

.step-content p {
    margin: 0;
    font-size: 0.95rem;
    color: #666;
    line-height: 1.6;
}

.methodology-divider {
    height: 20px;
    border-left: 2px dashed #e4451d;
    margin-left: 25px;
}

/* Imagem e Overlay */
.image-sticky {
    position: sticky;
    top: 20px;
}

.main-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.main-image img {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.main-image:hover img {
    transform: scale(1.05);
}

.image-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
    padding: 30px;
}

.specs-list {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
}

.spec-item {
    color: white;
    text-align: center;
}

.spec-item i {
    font-size: 24px;
    margin-bottom: 10px;
    color: #e4451d;
}

/* Resultados */
.results-box {
    background: white;
    border-radius: 15px;
    padding: 30px;
    margin-top: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.results-title {
    text-align: center;
    color: #00214e;
    font-weight: 600;
    margin-bottom: 25px;
}

.results-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
}

.result-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 10px;
    transition: all 0.3s ease;
}

.result-item:hover {
    transform: translateX(10px);
    background: #fff2f0;
}

.result-icon {
    width: 50px;
    height: 50px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.result-icon i {
    font-size: 20px;
    color: #e4451d;
}

.result-content {
    flex-grow: 1;
}

.result-content h4 {
    margin: 0 0 5px;
    font-size: 1rem;
    color: #444;
}

.result-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: #00214e;
}

/* Depoimento */
.testimonial-card {
    background: #00214e;
    color: white;
    border-radius: 15px;
    padding: 30px;
    margin-top: 30px;
    position: relative;
    overflow: hidden;
}

.testimonial-icon {
    position: absolute;
    top: 20px;
    left: 20px;
    opacity: 0.1;
    font-size: 4rem;
    color: #e4451d;
}

.testimonial-text {
    font-style: italic;
    font-size: 1.1rem;
    line-height: 1.7;
    margin: 0 0 20px;
    position: relative;
    z-index: 2;
}

.testimonial-author {
    display: flex;
    flex-direction: column;
}

.author-name {
    font-weight: 700;
    font-size: 1.1rem;
}

.author-title {
    font-size: 0.9rem;
    opacity: 0.7;
}

/* Setores */
.sectors-box {
    background: white;
    border-radius: 15px;
    padding: 30px;
    margin-top: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.sectors-title {
    text-align: center;
    color: #00214e;
    font-weight: 600;
    margin-bottom: 25px;
}

.sectors-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 15px;
}

.sector-tag {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 12px 15px;
    background: #f8f9fa;
    border-radius: 10px;
    transition: all 0.3s ease;
}

.sector-tag:hover {
    background: #fff2f0;
    transform: translateY(-5px);
}

.sector-tag i {
    color: #e4451d;
}

.sector-tag span {
    color: #444;
    font-weight: 500;
}

/* CTA Section */
.cta-section {
    text-align: center;
    padding: 60px;
    background: linear-gradient(45deg, #00214e, #003175);
    border-radius: 20px;
    color: white;
    margin-top: 60px;
}

.cta-content h2 {
    font-size: 2.5rem;
    margin-bottom: 20px;
}

.cta-content p {
    font-size: 1.2rem;
    margin-bottom: 30px;
    opacity: 0.9;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: white;
    color: #00214e;
    transform: translateY(-2px);
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid {
        grid-template-columns: 1fr;
    }

    .text-column {
        padding-right: 0;
    }

    .image-sticky {
        position: relative;
        top: 0;
        margin-top: 40px;
    }
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.2rem;
    }

    .text-content {
        padding: 20px;
    }

    .cta-section {
        padding: 40px 20px;
    }

    .cta-content h2 {
        font-size: 2rem;
    }

    .services-grid,
    .results-grid,
    .sectors-grid {
        grid-template-columns: 1fr;
    }

    .specs-list {
        grid-template-columns: 1fr;
        gap: 15px;
    }
}
</style>

<script>
    AOS.init({
        duration: 800,
        once: true
    });
</script>

<?php include 'footer.php'; ?>