<?php 
$pageTitle = 'Transporte Pneumático - Sierro Engenharia';
include 'header.php'; 
?>

<!-- Hero Section -->
<section class="hero-banner">
    <div class="container">
        <div class="hero-content">
            <h1 class="animate-up">Transporte Pneumático</h1>
            <div class="hero-divider animate-up"></div>
            <p class="hero-subtitle animate-up">Soluções eficientes para movimentação de materiais</p>
        </div>
    </div>
</section>

<!-- Conteúdo Principal -->
<main class="main-content">
    <div class="container">
        <!-- Grid Principal -->
        <div class="content-grid">
            <!-- Coluna de Texto -->
            <div class="text-column" data-aos="fade-right">
                <div class="text-content">
                    <div class="text-block">
                        <div class="section-tag">Conceito</div>
                        <p>
                            O transporte pneumático é uma técnica utilizada para mover materiais sólidos em forma de partículas ou granulados, por meios de equipamentos e tubulações, usando ar ou outro gás como meio transportador.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Modalidades</div>
                        <p>
                            Existem duas principais modalidades de transporte pneumático: fase densa e fase diluída, e a escolha entre uma e outra depende das características do material e das necessidades do processo.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Soluções Personalizadas</div>
                        <p>
                            A Sierro Engenharia desenvolve projetos sob medida para as necessidades específicas de cada cliente.
                        </p>
                    </div>

                    <!-- Modalidades Cards -->
                    <div class="modalities-comparison">
                        <h3 class="comparison-title">Comparativo entre Modalidades</h3>
                        
                        <div class="modalities-grid">
                            <div class="modality-card" data-aos="fade-up">
                                <div class="modality-header">
                                    <div class="modality-icon">
                                        <i class="fas fa-wind"></i>
                                    </div>
                                    <h3>Fase Diluída</h3>
                                </div>
                                <ul class="modality-features">
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Altas velocidades de transporte</span>
                                    </li>
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Baixa concentração de material</span>
                                    </li>
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Ideal para materiais leves</span>
                                    </li>
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Maiores distâncias de transporte</span>
                                    </li>
                                </ul>
                            </div>

                            <div class="modality-card" data-aos="fade-up" data-aos-delay="100">
                                <div class="modality-header">
                                    <div class="modality-icon">
                                        <i class="fas fa-compress-alt"></i>
                                    </div>
                                    <h3>Fase Densa</h3>
                                </div>
                                <ul class="modality-features">
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Baixas velocidades de transporte</span>
                                    </li>
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Alta concentração de material</span>
                                    </li>
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Ideal para materiais abrasivos</span>
                                    </li>
                                    <li>
                                        <i class="fas fa-check-circle"></i>
                                        <span>Menor consumo de energia</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Benefícios -->
                    <div class="benefits-section">
                        <h3 class="benefits-title">Benefícios do Transporte Pneumático</h3>
                        <div class="benefits-grid">
                            <div class="benefit-item" data-aos="fade-up">
                                <div class="benefit-icon">
                                    <i class="fas fa-shield-alt"></i>
                                </div>
                                <div class="benefit-content">
                                    <h4>Sistema Fechado</h4>
                                    <p>Protege o produto contra contaminantes e o ambiente contra poeira</p>
                                </div>
                            </div>
                            
                            <div class="benefit-item" data-aos="fade-up" data-aos-delay="100">
                                <div class="benefit-icon">
                                    <i class="fas fa-route"></i>
                                </div>
                                <div class="benefit-content">
                                    <h4>Flexibilidade</h4>
                                    <p>Traçados complexos com múltiplos pontos de entrega</p>
                                </div>
                            </div>
                            
                            <div class="benefit-item" data-aos="fade-up" data-aos-delay="200">
                                <div class="benefit-icon">
                                    <i class="fas fa-tachometer-alt"></i>
                                </div>
                                <div class="benefit-content">
                                    <h4>Eficiência</h4>
                                    <p>Transporte rápido e automático com baixa manutenção</p>
                                </div>
                            </div>
                            
                            <div class="benefit-item" data-aos="fade-up" data-aos-delay="300">
                                <div class="benefit-icon">
                                    <i class="fas fa-sitemap"></i>
                                </div>
                                <div class="benefit-content">
                                    <h4>Integração</h4>
                                    <p>Fácil integração com outros processos industriais</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="cta-section">
                        <div class="cta-content">
                            <h2>Precisa de um projeto personalizado?</h2>
                            <p>Entre em contato conosco para desenvolvermos a melhor solução para sua empresa</p>
                            <a href="contato.php" class="cta-button">
                                <span>Solicitar Orçamento</span>
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Coluna da Imagem -->
            <div class="image-column" data-aos="fade-left">
                <div class="image-sticky">
                    <div class="main-image">
                        <img src="images/transporte_pneumatico.png" alt="Sistema de Transporte Pneumático">
                        <div class="image-overlay">
                            <div class="specs-list">
                                <div class="spec-item">
                                    <i class="fas fa-sync-alt"></i>
                                    <span>Sistema Completo</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-cogs"></i>
                                    <span>Tecnologia Avançada</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-tools"></i>
                                    <span>Fácil Manutenção</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Aplicações -->
                    <div class="applications-box">
                        <h3 class="applications-title">Aplicações</h3>
                        <div class="applications-list">
                            <div class="application-tag">
                                <i class="fas fa-industry"></i>
                                <span>Indústria Alimentícia</span>
                            </div>
                            <div class="application-tag">
                                <i class="fas fa-flask"></i>
                                <span>Indústria Química</span>
                            </div>
                            <div class="application-tag">
                                <i class="fas fa-pills"></i>
                                <span>Indústria Farmacêutica</span>
                            </div>
                            <div class="application-tag">
                                <i class="fas fa-wine-bottle"></i>
                                <span>Plásticos e Polímeros</span>
                            </div>
                            <div class="application-tag">
                                <i class="fas fa-seedling"></i>
                                <span>Agroindústria</span>
                            </div>
                            <div class="application-tag">
                                <i class="fas fa-coffee"></i>
                                <span>Café e Derivados</span>
                            </div>
                        </div>
                    </div>

                    <!-- Indicadores de Performance -->
                    <div class="performance-stats">
                        <div class="stat-card">
                            <div class="stat-value">100%</div>
                            <div class="stat-label">Personalização</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-value">Alta</div>
                            <div class="stat-label">Eficiência</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-value">Mínima</div>
                            <div class="stat-label">Manutenção</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
/* Layout Principal */
.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

.main-content {
    padding: 80px 0;
    background: #f8f9fa;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

/* Hero Banner */
.hero-banner {
    background: linear-gradient(45deg, #00214e, #003175);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-banner::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 50%;
    height: 100%;
    background: url('assets/images/pattern.png') repeat;
    opacity: 0.1;
}

.hero-content {
    text-align: center;
    position: relative;
    z-index: 2;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto 20px;
}

.hero-subtitle {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* Texto e Conteúdo */
.text-column {
    padding-right: 40px;
}

.text-content {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.text-block {
    margin-bottom: 40px;
}

.section-tag {
    display: inline-block;
    padding: 8px 16px;
    background: #fff2f0;
    color: #e4451d;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 15px;
}

.text-block p {
    font-size: 1.2rem;
    line-height: 1.8;
    color: #444;
    text-align: justify;
    text-justify: inter-word;
    margin: 0;
}

/* Modalidades */
.modalities-comparison {
    margin: 50px 0;
}

.comparison-title {
    text-align: center;
    margin-bottom: 30px;
    color: #00214e;
    font-weight: 600;
}

.modalities-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 30px;
}

.modality-card {
    background: #f8f9fa;
    border-radius: 15px;
    padding: 30px;
    transition: all 0.3s ease;
}

.modality-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.1);
    background: #fff2f0;
}

.modality-header {
    display: flex;
    align-items: center;
    margin-bottom: 20px;
    gap: 15px;
}

.modality-icon {
    width: 50px;
    height: 50px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.modality-icon i {
    font-size: 20px;
    color: #e4451d;
}

.modality-header h3 {
    margin: 0;
    color: #00214e;
    font-weight: 600;
}

.modality-features {
    list-style: none;
    padding: 0;
    margin: 0;
}

.modality-features li {
    display: flex;
    align-items: flex-start;
    gap: 10px;
    padding: 10px 0;
    border-bottom: 1px solid rgba(0,0,0,0.05);
}

.modality-features li:last-child {
    border-bottom: none;
}

.modality-features i {
    color: #e4451d;
    margin-top: 5px;
}

/* Benefícios */
.benefits-section {
    margin-top: 50px;
    padding: 30px;
    background: #f8f9fa;
    border-radius: 15px;
}

.benefits-title {
    text-align: center;
    margin-bottom: 30px;
    color: #00214e;
    font-weight: 600;
}

.benefits-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
}

.benefit-item {
    display: flex;
    align-items: flex-start;
    background: white;
    padding: 20px;
    border-radius: 10px;
    gap: 15px;
    transition: all 0.3s ease;
}

.benefit-item:hover {
    transform: translateX(10px);
    background: #fff2f0;
}

.benefit-icon {
    width: 45px;
    height: 45px;
    background: #f8f9fa;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.benefit-icon i {
    font-size: 18px;
    color: #e4451d;
}

.benefit-content h4 {
    margin: 0 0 5px;
    color: #00214e;
    font-size: 1.1rem;
}

.benefit-content p {
    margin: 0;
    font-size: 0.9rem;
    color: #666;
}

/* Imagem e Overlay */
.image-sticky {
    position: sticky;
    top: 20px;
}

.main-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.main-image img {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.main-image:hover img {
    transform: scale(1.05);
}

.image-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
    padding: 30px;
}

.specs-list {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
}

.spec-item {
    color: white;
    text-align: center;
}

.spec-item i {
    font-size: 24px;
    margin-bottom: 10px;
    color: #e4451d;
}

/* Aplicações */
.applications-box {
    background: white;
    border-radius: 15px;
    padding: 30px;
    margin-top: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.applications-title {
    color: #00214e;
    font-weight: 600;
    text-align: center;
    margin-bottom: 20px;
}

.applications-list {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 15px;
}

.application-tag {
    background: #f8f9fa;
    padding: 10px 15px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
}

.application-tag:hover {
    background: #fff2f0;
    transform: translateY(-5px);
}

.application-tag i {
    color: #e4451d;
}

.application-tag span {
    font-size: 0.9rem;
    color: #444;
}

/* Performance Stats */
.performance-stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    margin-top: 30px;
}

.stat-card {
    background: white;
    padding: 20px;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 10px 20px rgba(0,0,0,0.05);
}

.stat-value {
    font-size: 1.8rem;
    font-weight: 700;
    color: #e4451d;
    margin-bottom: 5px;
}

.stat-label {
    color: #666;
    font-size: 0.9rem;
}

/* CTA Section */
.cta-section {
    text-align: center;
    padding: 60px;
    background: linear-gradient(45deg, #00214e, #003175);
    border-radius: 20px;
    color: white;
    margin-top: 60px;
}

.cta-content h2 {
    font-size: 2.5rem;
    margin-bottom: 20px;
}

.cta-content p {
    font-size: 1.2rem;
    margin-bottom: 30px;
    opacity: 0.9;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: white;
    color: #00214e;
    transform: translateY(-2px);
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid {
        grid-template-columns: 1fr;
    }

    .text-column {
        padding-right: 0;
    }

    .image-sticky {
        position: relative;
        top: 0;
        margin-top: 40px;
    }
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.2rem;
    }

    .text-content {
        padding: 20px;
    }

    .cta-section {
        padding: 40px 20px;
    }

    .cta-content h2 {
        font-size: 2rem;
    }

    .modalities-grid,
    .benefits-grid,
    .applications-list,
    .performance-stats {
        grid-template-columns: 1fr;
    }

    .specs-list {
        grid-template-columns: 1fr;
        gap: 15px;
    }
}
</style>

<script>
    AOS.init({
        duration: 800,
        once: true
    });
</script>

<?php include 'footer.php'; ?>